#include <LiquidCrystal.h>
#include <DS3231.h>
#include <Wire.h>
DS3231 Clock;
//LiquidCrystal(12,11,10,4,5,6,7);
bool Century=false;
bool h12;
bool PM;
byte ADay, AHour, AMinute, ASecond, ABits;
bool ADy, A12h, Apm;
byte year, month, date, week, hour, minute, second;
byte d[8]={
0b00111, //第一排的数据
0b00101, //第二排的数据
0b00111, //第三排的数据
0b00000, //第四排的数据
0b00000, //第五排的数据
0b00000, //第六排的数据
0b00000, //第七排的数据
0b00000, //第八排的数据
};
byte y[8]={
0b01000, //第一排的数据
0b01111, //第二排的数据
0b10010, //第三排的数据
0b01111, //第四排的数据
0b01010, //第五排的数据
0b11111, //第六排的数据
0b00010, //第七排的数据
0b00000, //第八排的数据
};
byte m[8]={
0b01111, //第一排的数据
0b01001, //第二排的数据
0b01111, //第三排的数据
0b01001, //第四排的数据
0b01111, //第五排的数据
0b01001, //第六排的数据
0b10011, //第七排的数据
0b00000, //第八排的数据
};
byte t[8]={
0b01111, //第一排的数据
0b01001, //第二排的数据
0b01001, //第三排的数据
0b01111, //第四排的数据
0b01001, //第五排的数据
0b01001, //第六排的数据
0b01111, //第七排的数据
0b00000, //第八排的数据
};
LiquidCrystal lcd=LiquidCrystal(12,11,10,4,5,6,7);
void setup() {
  lcd.begin(16,2);
  Serial.begin(9600);
  lcd.createChar(0,d);
  lcd.createChar(1,y);
  lcd.createChar(2,m);
  lcd.createChar(3,t);
}
/*void set()
{
    if(Serial.available()>0)
    {
      lcd.clear();
      lcd.setCursor(1,0);
      lcd.print("Set Time Mode");
      int i=0,n=0;
      int data[7]={0,0,0,0,0,0,0};
      char Serdata[18];
      while(i<=18)
      {
        Serdata[i]=Serial.read();
        i++;
      }
      i=0;
      while(i<=18)
      {
        if(Serdata[i+1]!=' ')
        {
          data[n]=data[n]+((int)(Serdata[i]-48))*10;
        }
        else
        {
          data[n]=data[n]+((int)(Serdata[i]-48));
          n++;
          i++;
        }
        i++;
      }
        Clock.setSecond(data[6]);
        Clock.setMinute(data[5]);
        Clock.setHour(data[4]);
        Clock.setDoW(data[3]);
        Clock.setDate(data[2]);
        Clock.setMonth(data[1]);
        Clock.setYear(data[0]); 
        Serial.print(data[0]);
        Serial.print(' ');
        Serial.print(data[1]);
        Serial.print(' ');
        Serial.print(data[2]);
        Serial.print(' ');
        Serial.print(data[3]);
        Serial.print(' ');
        Serial.print(data[4]);
        Serial.print(' ');
        Serial.print(data[5]);
        Serial.print(' ');
        Serial.print(data[6]);
        Serial.print('\n');
    }
}*/
void loop()
{
  
  int second,minute,hour,date,month,year,temperature;
  second=Clock.getSecond();
  minute=Clock.getMinute();
  hour=Clock.getHour(h12, PM);
  date=Clock.getDate();
  week=Clock.getDoW();   
  month=Clock.getMonth(Century);
  year=Clock.getYear();
  temperature=Clock.getTemperature();
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print(20);
  lcd.print(year);
  lcd.write(byte(1));
  lcd.print(month);
  lcd.write(byte(2));
  lcd.print(date);
  lcd.write(byte(3));
  lcd.print(' ');
  switch(week)
  {
    case 1: {
     lcd.print("Mon"); 
     }
     break;
    case 2: {
     lcd.print("Tue"); 
     }
     break;
    case 3: {
     lcd.print("Wed");  
     }
     break;
    case 4: {
      lcd.print("Thu"); 
      }
      break;
    case 5: {
      lcd.print("Fri");
      }
      break;
    case 6: {
      lcd.print("Sat");
      }
      break;
    case 7: {
      lcd.print("Sun");
      }
      break;
  }
  lcd.setCursor(0,1);
  if(hour<10) lcd.print(0);
  lcd.print(hour);
  lcd.print(':');
  if(minute<10) lcd.print(0);
  lcd.print(minute);
  lcd.print(':');
  if(second<10) lcd.print(0);
  lcd.print(second);
  lcd.print("  ");
  if(temperature<10) lcd.print(0);
  lcd.print(temperature);
  lcd.write(byte(0));
  lcd.print('C');
  digitalWrite(3,LOW);
  delay(100);
}
